package gov.va.med.mhv.usermgmt.data.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name = "USER_ACCEPT_EXT_TERMS_VER")
public class UserAcceptExtTermsVer implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 9187874546521349524L;

	@Id
	@Column(name = "USER_ACCEPT_EXT_TERMS_VER_ID")	
	@GeneratedValue(strategy = GenerationType.AUTO) 
 	private Long id;
	
	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;

	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;
	
	@Column(name = "USER_PROFILE_ID")
	private Long userProfileId;

	@Column(name = "EXT_TERMS_CONDITIONS_EVENT", updatable = false)
	private String extTermsCondEvent;

	
	@Column(name = "EXT_TERMS_CONDITIONS_VER", updatable = false)
	private String extTermsCondVer;

	@Column(name = "EXT_TERMS_CONDITIONS_NOTES", updatable = false)
	private String extTermsCondVerNotes;

	@Column(name = "ACCEPTED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date acceptedDate;
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public String getExtTermsCondEvent() {
		return extTermsCondEvent;
	}

	public void setExtTermsCondEvent(String extTermsCondEvent) {
		this.extTermsCondEvent = extTermsCondEvent;
	}

	public String getExtTermsCondVer() {
		return extTermsCondVer;
	}

	public void setExtTermsCondVer(String extTermsCondVer) {
		this.extTermsCondVer = extTermsCondVer;
	}

	public String getExtTermsCondVerNotes() {
		return extTermsCondVerNotes;
	}

	public void setExtTermsCondVerNotes(String extTermsCondVerNotes) {
		this.extTermsCondVerNotes = extTermsCondVerNotes;
	}

	public Date getAcceptedDate() {
		return acceptedDate;
	}

	public void setAcceptedDate(Date acceptedDate) {
		this.acceptedDate = acceptedDate;
	}

	

}
